package data.scripts.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent.SkillPickPreference;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.ids.Personalities;
import com.fs.starfarer.api.loading.FleetCompositionDoctrineAPI;
import com.fs.starfarer.api.plugins.OfficerLevelupPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class SWP_FleetFactory {

    public static void addCommanderAndOfficersFamous(int total, float minLevel, float maxLevel, CampaignFleetAPI fleet,
                                                     Collection<FleetMemberAPI> specialShips, Random random) {
        OfficerLevelupPlugin plugin = (OfficerLevelupPlugin) Global.getSettings().getPlugin("officerLevelUp");
        int max = plugin.getMaxLevel(null);

        List<FleetMemberAPI> members = fleet.getFleetData().getMembersListCopy();

        WeightedRandomPicker<FleetMemberAPI> picker = new WeightedRandomPicker<>(random);

        for (FleetMemberAPI member : members) {
            if (member.isFighterWing()) {
                continue;
            }
            if (member.isFlagship()) {
                continue;
            }
            if (!member.getCaptain().isDefault()) {
                continue;
            }

            float q = member.getVariant().getQuality();
            if (member.isCivilian()) {
                q *= 0.0001f;
            }
            for (FleetMemberAPI special : specialShips) {
                if (special.getId().contentEquals(member.getId())) {
                    q += 1000f;
                    break;
                }
            }
            float weight = member.getFleetPointCost() * 0.5f + member.getFleetPointCost() * q;
            picker.add(member, weight);
        }

        for (int i = 0; i < total + 1; i++) {
            FleetMemberAPI member = picker.pickAndRemove();

            if (member == null) {
                break; // out of ships that need officers
            }

            int level = Math.min(max, Math.round(minLevel + random.nextFloat() * (maxLevel - minLevel)));
            if (Misc.isEasy()) {
                level = (int) Math.ceil(level * Global.getSettings().getFloat("easyOfficerLevelMult"));
            }

            if (level <= 0) {
                continue;
            }

            float weight = FleetFactoryV2.getMemberWeight(member);
            float fighters = member.getVariant().getFittedWings().size();
            boolean wantCarrierSkills = weight > 0 && fighters / weight >= 0.5f;
            SkillPickPreference pref = SkillPickPreference.NON_CARRIER;
            if (wantCarrierSkills) {
                pref = SkillPickPreference.CARRIER;
            }

            PersonAPI person = OfficerManagerEvent.createOfficer(fleet.getFaction(), level, true, pref, random);
            if (person.getPersonalityAPI().getId().equals(Personalities.TIMID)) {
                person.setPersonality(Personalities.CAUTIOUS);
            }

            member.setCaptain(person);
        }
    }

    public static CampaignFleetAPI enhancedCreateFleet(FactionAPI faction, int fleetSize, FleetFactoryDelegate delegate) {
        FleetCompositionDoctrineAPI doctrine = faction.getCompositionDoctrine();
        float preSmall = doctrine.getSmall();
        float preFast = doctrine.getFast();
        float preMedium = doctrine.getMedium();
        float preLarge = doctrine.getLarge();
        float preCapital = doctrine.getCapital();
        float preSmallCarrierProbability = doctrine.getSmallCarrierProbability();
        float preMediumCarrierProbability = doctrine.getMediumCarrierProbability();
        float preLargeCarrierProbability = doctrine.getLargeCarrierProbability();

        if (fleetSize > 25 && fleetSize <= 50) {
            doctrine.setSmall(preSmall * 0.5f);
            doctrine.setFast(preFast * 0.5f);
            doctrine.setMedium(preMedium);
            doctrine.setLarge(preLarge * 1.25f);
            doctrine.setCapital(preCapital * 1.5f);
            doctrine.setSmallCarrierProbability(preSmallCarrierProbability * 0.8f);
            doctrine.setMediumCarrierProbability(preMediumCarrierProbability * 0.9f);
            doctrine.setLargeCarrierProbability(preLargeCarrierProbability);
        } else if (fleetSize > 50 && fleetSize <= 100) {
            doctrine.setSmall(preSmall * 0.25f);
            doctrine.setFast(preFast * 0.25f);
            doctrine.setMedium(preMedium * 0.75f);
            doctrine.setLarge(preLarge);
            doctrine.setCapital(preCapital * 1.25f);
            doctrine.setSmallCarrierProbability(preSmallCarrierProbability * 0.5f);
            doctrine.setMediumCarrierProbability(preMediumCarrierProbability * 0.65f);
            doctrine.setLargeCarrierProbability(preLargeCarrierProbability * 0.8f);
        } else if (fleetSize > 100) {
            doctrine.setSmall(preSmall * 0.125f);
            doctrine.setFast(preFast * 0.125f);
            doctrine.setMedium(preMedium * 0.375f);
            doctrine.setLarge(preLarge * 0.75f);
            doctrine.setCapital(preCapital);
            doctrine.setSmallCarrierProbability(preSmallCarrierProbability * 0.2f);
            doctrine.setMediumCarrierProbability(preMediumCarrierProbability * 0.4f);
            doctrine.setLargeCarrierProbability(preLargeCarrierProbability * 0.6f);
        }

        CampaignFleetAPI fleet = delegate.createFleet();

        doctrine.setSmall(preSmall);
        doctrine.setFast(preFast);
        doctrine.setMedium(preMedium);
        doctrine.setLarge(preLarge);
        doctrine.setCapital(preCapital);
        doctrine.setSmallCarrierProbability(preSmallCarrierProbability);
        doctrine.setMediumCarrierProbability(preMediumCarrierProbability);
        doctrine.setLargeCarrierProbability(preLargeCarrierProbability);

        return fleet;
    }

    @SuppressWarnings("AssignmentToMethodParameter")
    public static void levelOfficer(PersonAPI person, FleetDataAPI fleetData, int toLevel, boolean alwaysPickHigherSkill,
                                    SkillPickPreference pref, Random random) {
        if (random == null) {
            random = new Random();
        }

        OfficerLevelupPlugin plugin = (OfficerLevelupPlugin) Global.getSettings().getPlugin("officerLevelUp");
        if (toLevel > plugin.getMaxLevel(person)) {
            toLevel = plugin.getMaxLevel(person);
        }
        person.getStats().setSkipRefresh(true);

        OfficerDataAPI officerData = fleetData.getOfficerData(person);
        if (officerData == null) {
            officerData = Global.getFactory().createOfficerData(person);
        }

        long xp = plugin.getXPForLevel(toLevel);
        officerData.addXP(xp - person.getStats().getXP());
        while (officerData.canLevelUp()) {
            String skillId =
                   OfficerManagerEvent.pickSkill(officerData.getPerson(), officerData.getSkillPicks(),
                                                 alwaysPickHigherSkill, pref, random);
            if (skillId != null) {
                officerData.levelUp(skillId);
            }
        }

        person.getStats().setSkipRefresh(false);
        person.getStats().refreshCharacterStatsEffects();
    }

    public interface FleetFactoryDelegate {

        public CampaignFleetAPI createFleet();
    }
}
